Attribute VB_Name = "Edit"
'	This is a part of the source code for Pro/DESKTOP.
'	Copyright (C) 1999 Parametric Technology Corporation.
'	All rights reserved.


Sub menuOffsetChain()

If prod Is Nothing Then
    MsgBox "Could not get the application", vbExclamation, "Error"
    Exit Sub
End If

'Take the helm
Dim api As helm
Set api = prod.TakeHelm

On Error GoTo NoDocErr

Dim activePart As PartDocument
Set activePart = prod.GetActiveDoc()

On Error GoTo 0

Dim objset As ObjectSet
Set objset = activePart.GetSelection("Line")

If objset.IsEmpty Then
    MsgBox "Lines not Selected"
    Exit Sub
End If

If (objset.GetAnyMember.IsA("Line")) Then

    cfobject.offsetchain objset, 0.05, 2
Else
    MsgBox "Entities selected are not lines"
End If

api.CommitCalls "offsetchain", pause

Exit Sub

NoDocErr:
        MsgBox "Could not get the Active Part", vbExclamation, "Error"
        Exit Sub

End Sub

Sub menuDelete()

If prod Is Nothing Then
    MsgBox "Could not get the application", vbExclamation, "Error"
    Exit Sub
End If

'Take the helm
Dim api As helm
Set api = prod.TakeHelm

On Error GoTo NoDocErr

Dim activePart As PartDocument
Set activePart = prod.GetActiveDoc()

On Error GoTo 0

Dim objset As ObjectSet
Set objset = activePart.GetSelection("Line")

If objset.IsEmpty Then
    MsgBox "Lines not Selected"
    Exit Sub
End If

If (objset.GetAnyMember.IsA("Line")) Then
    
    cfobject.DeleteLines objset
Else
    MsgBox "Entities selected are not lines"
End If

api.CommitCalls "DeleteLines", pause

Exit Sub

NoDocErr:
        MsgBox "Could not get the Active Part", vbExclamation, "Error"
        Exit Sub

End Sub

Sub menuTranslateObjects()

If prod Is Nothing Then
    MsgBox "Could not get the application", vbExclamation, "Error"
    Exit Sub
End If

'Take the helm
Dim api As helm
Set api = prod.TakeHelm

On Error GoTo NoDocErr

Dim activePart As PartDocument
Set activePart = prod.GetActiveDoc()

On Error GoTo 0

Dim objset As ObjectSet
Set objset = activePart.GetSelection("Line")

If objset.IsEmpty Then
    MsgBox "Lines not Selected"
    Exit Sub
End If

If (objset.GetAnyMember.IsA("Line")) Then

    cfobject.TranslateObjects 0.05, 0.05, objset
    
Else
    MsgBox "Entities selected are not lines"
End If

api.CommitCalls "TranslateObjects", pause

Exit Sub

NoDocErr:
MsgBox "Could not get the Active Part", vbExclamation, "Error"
Exit Sub

End Sub

Sub menuRotateObjects()

If prod Is Nothing Then
    MsgBox "Could not get the application", vbExclamation, "Error"
    Exit Sub
End If

'Take the helm
Dim api As helm
Set api = prod.TakeHelm

On Error GoTo NoDocErr

Dim activePart As PartDocument
Set activePart = prod.GetActiveDoc()

On Error GoTo 0

Dim objset As ObjectSet
Set objset = activePart.GetSelection("Line")

If objset.IsEmpty Then
    MsgBox "Lines not Selected"
    Exit Sub
End If

If (objset.GetAnyMember.IsA("Line")) Then

    cfobject.RotateObjects 45, objset
    
Else
    MsgBox "Entities selected are not lines"
End If

api.CommitCalls "RotateObjects", pause

Exit Sub

NoDocErr:
        MsgBox "Could not get the Active Part", vbExclamation, "Error"
        Exit Sub

End Sub

Sub menuScaleObjects()

If prod Is Nothing Then
    MsgBox "Could not get the application", vbExclamation, "Error"
    Exit Sub
End If

'Take the helm
Dim api As helm
Set api = prod.TakeHelm

On Error GoTo NoDocErr

Dim activePart As PartDocument
Set activePart = prod.GetActiveDoc()

On Error GoTo 0

Dim objset As ObjectSet
Set objset = activePart.GetSelection("Line")

If objset.IsEmpty Then
    MsgBox "Lines not Selected"
    Exit Sub
End If

If (objset.GetAnyMember.IsA("Line")) Then

    cfobject.ScaleObjects 2, objset
   
Else
    MsgBox "Entities selected are not lines"
End If

api.CommitCalls "ScaleObjects", pause

Exit Sub

NoDocErr:
        MsgBox "Could not get the Active Part", vbExclamation, "Error"
        Exit Sub

End Sub

Sub menuRectangularDuplicate()

If prod Is Nothing Then
    MsgBox "Could not get the application", vbExclamation, "Error"
    Exit Sub
End If

'Take the helm
Dim api As helm
Set api = prod.TakeHelm

On Error GoTo NoDocErr

Dim activePart As PartDocument
Set activePart = prod.GetActiveDoc()

On Error GoTo 0

Dim objset As ObjectSet
Set objset = activePart.GetSelection("Line")

If objset.IsEmpty Then
    MsgBox "Lines not Selected"
    Exit Sub
End If

If (objset.GetAnyMember.IsA("Line")) Then

    cfobject.RectangularDuplicate 4, 4, 0.1, 0.1, objset
    
Else
    MsgBox "Entities selected are not lines"
End If

api.CommitCalls "RectangularDuplicate", pause

Exit Sub

NoDocErr:
        MsgBox "Could not get the Active Part", vbExclamation, "Error"
        Exit Sub

End Sub

Sub menuCircularDuplicate()

If prod Is Nothing Then
    MsgBox "Could not get the application", vbExclamation, "Error"
    Exit Sub
End If

'Take the helm
Dim api As helm
Set api = prod.TakeHelm

On Error GoTo NoDocErr

Dim activePart As PartDocument
Set activePart = prod.GetActiveDoc()

On Error GoTo 0

Dim objset As ObjectSet
Set objset = activePart.GetSelection("Line")

If objset.IsEmpty Then
    MsgBox "Lines not Selected"
    Exit Sub
End If

If (objset.GetAnyMember.IsA("Line")) Then

    cfobject.CircularDuplicate 6, 360, True, objset
        
Else
    MsgBox "Entities selected are not lines"
End If

api.CommitCalls "CircularDuplicate", pause

Exit Sub

NoDocErr:
        MsgBox "Could not get the Active Part", vbExclamation, "Error"
        Exit Sub

End Sub

Sub menuMirrorInX()

If prod Is Nothing Then
    MsgBox "Could not get the application", vbExclamation, "Error"
    Exit Sub
End If

'Take the helm
Dim api As helm
Set api = prod.TakeHelm

On Error GoTo NoDocErr

Dim activePart As PartDocument
Set activePart = prod.GetActiveDoc()

On Error GoTo 0

Dim objset As ObjectSet
Set objset = activePart.GetSelection("Line")

If objset.IsEmpty Then
    MsgBox "Lines not Selected"
    Exit Sub
End If

If (objset.GetAnyMember.IsA("Line")) Then

    cfobject.MirrorInX objset
    
Else
    MsgBox "Entities selected are not lines"
End If

api.CommitCalls "MirrorInX", pause

Exit Sub

NoDocErr:
        MsgBox "Could not get the Active Part", vbExclamation, "Error"
        Exit Sub

End Sub

Sub menuMirrorInY()

If prod Is Nothing Then
    MsgBox "Could not get the application", vbExclamation, "Error"
    Exit Sub
End If

'Take the helm
Dim api As helm
Set api = prod.TakeHelm

On Error GoTo NoDocErr

Dim activePart As PartDocument
Set activePart = prod.GetActiveDoc()

On Error GoTo 0

Dim objset As ObjectSet
Set objset = activePart.GetSelection("Line")

If objset.IsEmpty Then
    MsgBox "Lines not Selected"
    Exit Sub
End If

If (objset.GetAnyMember.IsA("Line")) Then

    cfobject.MirrorInY objset
    
Else
    MsgBox "Entities selected are not lines"
End If

api.CommitCalls "MirrorInY", pause

Exit Sub

NoDocErr:
        MsgBox "Could not get the Active Part", vbExclamation, "Error"
        Exit Sub

End Sub

Sub menuMirrorInBoth()

If prod Is Nothing Then
    MsgBox "Could not get the application", vbExclamation, "Error"
    Exit Sub
End If

'Take the helm
Dim api As helm
Set api = prod.TakeHelm

On Error GoTo NoDocErr

Dim activePart As PartDocument
Set activePart = prod.GetActiveDoc()

On Error GoTo 0

Dim objset As ObjectSet
Set objset = activePart.GetSelection("Line")

If objset.IsEmpty Then
    MsgBox "Lines not Selected"
    Exit Sub
End If

If (objset.GetAnyMember.IsA("Line")) Then

    cfobject.MirrorInBoth objset
    
Else
    MsgBox "Entities selected are not lines"
End If

api.CommitCalls "MirrorInBoth", pause

Exit Sub

NoDocErr:
        MsgBox "Could not get the Active Part", vbExclamation, "Error"
        Exit Sub

End Sub


